#include "bdtypes.h"
#include "bdfunc.h"
#include "bdglobal.h"

#define IS_NEG(param) ((*(DWORD*)&(param))&(1<<31))

static float IdentityMatrix[] = {
	1,0,0,0,
	0,1,0,0,
	0,0,1,0,
	0,0,0,1
};

static float RotateMatrix[16];
static Face FacesClipped[5000];
static GrVertex VtxClipped[5000];

const float vertex_snapper = ( float ) ( 3L << 18 );

void ComputeGouraud(Obj3d* pObj)
{
	// The normal !
	float xVertex,yVertex,zVertex; // The normal of a vertex
	FbVertex *pVertexIn;
	Face *pFace; // The faces list
	FbVertex *pA, *pB, *pC; // pointers to the vertexes of the face
	Vector Vector1, Vector2;
	unsigned int Cpt1, Cpt2;
	float Dst;

	if (pObj==NULL)
		return;

	pFace = pObj->pFace;
	pVertexIn = pObj->pVertexIn;

	// for earch point, compute the normal

	for(Cpt1=0;Cpt1<pObj->NbFaces;Cpt1++)
	{
		// get the pointer to the Vertexes
		pA = &pVertexIn[pFace[Cpt1].A];
		pB = &pVertexIn[pFace[Cpt1].B];
		pC = &pVertexIn[pFace[Cpt1].C];

		// Calculate vectors
		//        ->
		// vector AB
		Vector1.x = pB->x - pA->x;
		Vector1.y = pB->y - pA->y;
		Vector1.z = pB->z - pA->z;
		//        ->
		// vector AC
		Vector2.x = pC->x - pA->x;
		Vector2.y = pC->y - pA->y;
		Vector2.z = pC->z - pA->z;

		// Compute the normal of the face;
		pFace[Cpt1].xNorm = (Vector1.y * Vector2.z) - (Vector1.z * Vector2.y);
		pFace[Cpt1].yNorm = (Vector1.z * Vector2.x) - (Vector1.x * Vector2.z);
		pFace[Cpt1].zNorm = (Vector1.x * Vector2.y) - (Vector1.y * Vector2.x);

		// Normalize the normal, and add to ?Vertex
		Dst = (float)sqrt(pFace[Cpt1].xNorm*pFace[Cpt1].xNorm
						+ pFace[Cpt1].yNorm*pFace[Cpt1].yNorm
						+ pFace[Cpt1].zNorm*pFace[Cpt1].zNorm);
		pFace[Cpt1].xNorm /= Dst;
		pFace[Cpt1].yNorm /= Dst;
		pFace[Cpt1].zNorm /= Dst;
	}

	for(Cpt1=0;Cpt1<pObj->NbVertex;Cpt1++)
	{
		// for earch faces
		xVertex=0;yVertex=0;zVertex=0;
		for(Cpt2=0;Cpt2<pObj->NbFaces;Cpt2++)
		{
			if ((pFace[Cpt2].A != Cpt1) && (pFace[Cpt2].B != Cpt1) && (pFace[Cpt2].C != Cpt1))
				continue;

			xVertex += pFace[Cpt2].xNorm;
			yVertex += pFace[Cpt2].yNorm;
			zVertex += pFace[Cpt2].zNorm;
		}
		// Then normalize sum of normals
		Dst = (float)sqrt(xVertex*xVertex + yVertex*yVertex + zVertex*zVertex);
		pVertexIn[Cpt1].xNorm = xVertex / Dst;
		pVertexIn[Cpt1].yNorm = yVertex / Dst;
		pVertexIn[Cpt1].zNorm = zVertex / Dst;

	}
}


void MulMatrix(float *Dst, float *A, float *B)
{
	int Cpt1, Cpt2, Cpt3;

	for(Cpt1=0;Cpt1<16;Cpt1+=4) // num de lignes
	{
		for(Cpt2=0;Cpt2<4;Cpt2++) // num de colonne
		{
			Dst[Cpt1+Cpt2] = 0;
			for(Cpt3=0; Cpt3<4;Cpt3++)
			{
				Dst[Cpt1+Cpt2] += A[Cpt1+Cpt3] * B[Cpt3*4+Cpt2];
			}
		}
	}
}

void CopyMatrix(float *Dst, float *Src)
{
	memcpy(Dst, Src, 16*4);
}

void CopyMatrixSpecial(float *Dst, float *Src)
{
	int Cpt1;

	for(Cpt1=0;Cpt1<11;Cpt1++)
	{
		Dst[Cpt1] = Src[10-Cpt1];
	}
	Dst[11] = Src[11];
	Dst[12] = Src[12];
	Dst[13] = Src[13];
	Dst[14] = Src[14];
	Dst[15] = Src[15];
}

void BeIdentityMatrix(float* Dst)
{
#ifdef WIN32
	_asm
	{
		mov edi, DWORD PTR Dst
		mov esi, OFFSET IdentityMatrix
		mov ecx, 16
		rep movsd
	}
#else
	__asm__ __volatile__("
		movl %0, %%edi
		movl %1, %%esi
		movl $16, %%ecx
		rep
		movsl
	"
	:
	: "g" (Dst), "g" (IdentityMatrix)
	);
#endif
}

void TranslateMatrix(float *Dst, float x, float y, float z)
{
	Dst[3] += x;
	Dst[7] += y;
	Dst[11] += z;
}

// rotating

void RotateXMatrix(float *Dst, float *Src, int Nb)
{
	BeIdentityMatrix(RotateMatrix);
	RotateMatrix[5] = CosTable[Nb&8191];
	RotateMatrix[6] = -SinTable[Nb&8191];
	RotateMatrix[9] = SinTable[Nb&8191];
	RotateMatrix[10] = CosTable[Nb&8191];
	MulMatrix(Dst, RotateMatrix, Src);
}

void RotateYMatrix(float *Dst, float *Src, int Nb)
{
	BeIdentityMatrix(RotateMatrix);
	RotateMatrix[0] = CosTable[Nb&8191];
	RotateMatrix[2] = SinTable[Nb&8191];
	RotateMatrix[8] = -SinTable[Nb&8191];
	RotateMatrix[10] = CosTable[Nb&8191];
	MulMatrix(Dst, RotateMatrix, Src);
}

void RotateZMatrix(float *Dst, float *Src, int Nb)
{
	BeIdentityMatrix(RotateMatrix);
	RotateMatrix[0] = CosTable[Nb&8191];
	RotateMatrix[1] = -SinTable[Nb&8191];
	RotateMatrix[4] = SinTable[Nb&8191];
	RotateMatrix[5] = CosTable[Nb&8191];
	MulMatrix(Dst, RotateMatrix, Src);
}

void ScaleXMatrix(float *Dst, float Nb)
{
	Dst[0] *= Nb;
}

void ScaleYMatrix(float *Dst, float Nb)
{
	Dst[5] *= Nb;
}


void ScaleZMatrix(float *Dst, float Nb)
{
	Dst[10] *= Nb;
}

void ScaleMatrix(float *Dst, float X, float Y, float Z)
{

	Dst[0] *= X;
	Dst[1] *= X;
	Dst[2] *= X;
	Dst[3] *= X;

	Dst[4] *= Y;
	Dst[5] *= Y;
	Dst[6] *= Y;
	Dst[7] *= Y;

	Dst[8] *= Z;
	Dst[9] *= Z;
	Dst[10] *= Z;
	Dst[11] *= Z;
}

void DrawWithMatrix(Obj3d *pObj, float *Matrix, BOOL bGouraud, float *Gouraud, DWORD dwSowTow)
{
	FbVertex *pVertexIn;
	GrVertex *pVertexOut, *pCurrentOut;
	DWORD NbVertex;
	Face *pFace;
	unsigned int NbFaces;
	DWORD Cpt1, Cpt2;
	float LightPower;
	float oow320;

	DWORD NbFacesClipped = 0;
	DWORD NbVtxClipped = 0;
	Face *pCurrFaceClipped;
	GrVertex *pCurrVtxClipped;

	pVertexIn = pObj->pVertexIn;
	pCurrentOut = pVertexOut = pObj->pVertexOut;
	NbVertex = pObj->NbVertex;	

	if (dwSowTow == false)
	{
		if (bGouraud == false)
		{
			for(Cpt1=0;Cpt1<NbVertex;Cpt1++)
			{
				pCurrentOut->z = Matrix[8] * pVertexIn->x + Matrix[9] * pVertexIn->y 
									+ Matrix[10] * pVertexIn->z + Matrix[11];
				pCurrentOut->x = Matrix[0] * pVertexIn->x + Matrix[1] * pVertexIn->y 
									+ Matrix[2] * pVertexIn->z + Matrix[3];
				pCurrentOut->y = Matrix[4] * pVertexIn->x + Matrix[5] * pVertexIn->y 
									+ Matrix[6] * pVertexIn->z + Matrix[7];

				pCurrentOut->tmuvtx[0].sow = pVertexIn->tmuvtx[0].sow;
				pCurrentOut->tmuvtx[0].tow = pVertexIn->tmuvtx[0].tow;

				pVertexIn++;
				pCurrentOut++;
			}
		}
		else // Gouraud
		{
			float Gx, Gy, Gz;

			Gx = Gouraud[0] * 0 + Gouraud[1] * 0 + Gouraud[2] * -1;
			Gy = Gouraud[4] * 0 + Gouraud[5] * 0 + Gouraud[6] * -1;
			Gz = Gouraud[8] * 0 + Gouraud[9] * 0 + Gouraud[10] * -1;

			for(Cpt1=0;Cpt1<NbVertex;Cpt1++)
			{
				pCurrentOut->z = Matrix[8] * pVertexIn->x + Matrix[9] * pVertexIn->y 
									+ Matrix[10] * pVertexIn->z + Matrix[11];
				pCurrentOut->x = Matrix[0] * pVertexIn->x + Matrix[1] * pVertexIn->y 
									+ Matrix[2] * pVertexIn->z + Matrix[3];
				pCurrentOut->y = Matrix[4] * pVertexIn->x + Matrix[5] * pVertexIn->y 
									+ Matrix[6] * pVertexIn->z + Matrix[7];
				
				pCurrentOut->tmuvtx[0].sow = pVertexIn->tmuvtx[0].sow;
				pCurrentOut->tmuvtx[0].tow = pVertexIn->tmuvtx[0].tow;

				LightPower = ( Gx * pVertexIn->xNorm + Gy * pVertexIn->yNorm
								+ Gz * pVertexIn->zNorm);

				LightPower = LightPower * 255;
				
				if (LightPower<0)
					LightPower = 0;
				if (LightPower>255)
					LightPower = 255;

				pCurrentOut->r = LightPower;
				pCurrentOut->g = LightPower;
				pCurrentOut->b = LightPower;

				pVertexIn++;
				pCurrentOut++;
			}
		}
	}
	else // SowTow
	{
		if (bGouraud == false)
		{
			for(Cpt1=0;Cpt1<NbVertex;Cpt1++)
			{
				pCurrentOut->z = Matrix[8] * pVertexIn->x + Matrix[9] * pVertexIn->y 
									+ Matrix[10] * pVertexIn->z + Matrix[11];
				pCurrentOut->x = Matrix[0] * pVertexIn->x + Matrix[1] * pVertexIn->y 
									+ Matrix[2] * pVertexIn->z + Matrix[3];
				pCurrentOut->y = Matrix[4] * pVertexIn->x + Matrix[5] * pVertexIn->y 
									+ Matrix[6] * pVertexIn->z + Matrix[7];

				pVertexIn++;
				pCurrentOut++;
			}
		}
		else // Gouraud
		{
			float Gx, Gy, Gz;

			Gx = Gouraud[0] * 0 + Gouraud[1] * 0 + Gouraud[2] * -1;
			Gy = Gouraud[4] * 0 + Gouraud[5] * 0 + Gouraud[6] * -1;
			Gz = Gouraud[8] * 0 + Gouraud[9] * 0 + Gouraud[10] * -1;

			for(Cpt1=0;Cpt1<NbVertex;Cpt1++)
			{
				pCurrentOut->z = Matrix[8] * pVertexIn->x + Matrix[9] * pVertexIn->y 
									+ Matrix[10] * pVertexIn->z + Matrix[11];
				pCurrentOut->x = Matrix[0] * pVertexIn->x + Matrix[1] * pVertexIn->y 
									+ Matrix[2] * pVertexIn->z + Matrix[3];
				pCurrentOut->y = Matrix[4] * pVertexIn->x + Matrix[5] * pVertexIn->y 
									+ Matrix[6] * pVertexIn->z + Matrix[7];
				
				LightPower = ( Gx * pVertexIn->xNorm + Gy * pVertexIn->yNorm
								+ Gz * pVertexIn->zNorm);

				LightPower = LightPower * 255;
				
				if (LightPower<0)
					LightPower = 0;
				if (LightPower>255)
					LightPower = 255;

				pCurrentOut->r = LightPower;
				pCurrentOut->g = LightPower;
				pCurrentOut->b = LightPower;

				pVertexIn++;
				pCurrentOut++;
			}
		}
	}
	// Remove and create faces

	NbFaces = pObj->NbFaces;
	pFace = pObj->pFace;

	pCurrFaceClipped = &FacesClipped[0];
	pCurrVtxClipped = &VtxClipped[0];

	for(Cpt1=0;Cpt1<NbFaces;Cpt1++)
	{
		float fRatio;
		GrVertex *pA = pVertexOut+pFace->A;
		GrVertex *pB = pVertexOut+pFace->B;
		GrVertex *pC = pVertexOut+pFace->C;

		if (IS_NEG(pA->z))
		{
			if (IS_NEG(pB->z))
			{
				if (IS_NEG(pC->z))
				{
					// All neg ! See nothing
					pFace->IsVisible = false;
				}
				else
				{
					// A and B are NEG; keep C
					pCurrFaceClipped->A = NbVtxClipped;
					pCurrFaceClipped->B = NbVtxClipped+1;
					pCurrFaceClipped->C = NbVtxClipped+2;
					pCurrFaceClipped++;
					NbFacesClipped++;

					// Compute A
					fRatio = (pC->z)/(pC->z - pA->z);
					pCurrVtxClipped->z = pCurrVtxClipped->oow = 1.f;
					pCurrVtxClipped->x = pC->x + (pA->x - pC->x)*fRatio;
					pCurrVtxClipped->y = pC->y + (pA->y - pC->y)*fRatio;
					pCurrVtxClipped->r = pC->r + (pA->r - pC->r)*fRatio;
					pCurrVtxClipped->g = pC->g + (pA->g - pC->g)*fRatio;
					pCurrVtxClipped->b = pC->b + (pA->b - pC->b)*fRatio;
					pCurrVtxClipped->tmuvtx[0].sow = pC->tmuvtx[0].sow + (pA->tmuvtx[0].sow - pC->tmuvtx[0].sow)*fRatio;
					pCurrVtxClipped->tmuvtx[0].tow = pC->tmuvtx[0].tow + (pA->tmuvtx[0].tow - pC->tmuvtx[0].tow)*fRatio;
					NbVtxClipped++; pCurrVtxClipped++;

					// Compute B
					fRatio = (pC->z)/(pC->z - pB->z);
					pCurrVtxClipped->z = pCurrVtxClipped->oow = 1.f;
					pCurrVtxClipped->x = pC->x + (pB->x - pC->x)*fRatio;
					pCurrVtxClipped->y = pC->y + (pB->y - pC->y)*fRatio;
					pCurrVtxClipped->r = pC->r + (pB->r - pC->r)*fRatio;
					pCurrVtxClipped->g = pC->g + (pB->g - pC->g)*fRatio;
					pCurrVtxClipped->b = pC->b + (pB->b - pC->b)*fRatio;
					pCurrVtxClipped->tmuvtx[0].sow = pC->tmuvtx[0].sow + (pB->tmuvtx[0].sow - pC->tmuvtx[0].sow)*fRatio;
					pCurrVtxClipped->tmuvtx[0].tow = pC->tmuvtx[0].tow + (pB->tmuvtx[0].tow - pC->tmuvtx[0].tow)*fRatio;
					NbVtxClipped++; pCurrVtxClipped++;
					// Copy C
					/*pCurrVtxClipped->x = pC->x;					
					pCurrVtxClipped->y = pC->y;
					pCurrVtxClipped->z = pC->z;
					pCurrVtxClipped->r = pC->r;
					pCurrVtxClipped->g = pC->g;
					pCurrVtxClipped->b = pC->b;
					pCurrVtxClipped->a = pC->a;
					pCurrVtxClipped->tmuvtx[0].sow = pC->tmuvtx[0].sow;
					pCurrVtxClipped->tmuvtx[0].tow = pC->tmuvtx[0].tow;*/
					memcpy(pCurrVtxClipped, pC, sizeof(GrVertex)-sizeof(GrTmuVertex)-4);
					NbVtxClipped++; pCurrVtxClipped++;

					pFace->IsVisible = false;
				}
			}
			else
			{
				if (IS_NEG(pC->z))
				{
					// A and C are NEG; keep B
					pCurrFaceClipped->A = NbVtxClipped;
					pCurrFaceClipped->B = NbVtxClipped+1;
					pCurrFaceClipped->C = NbVtxClipped+2;
					pCurrFaceClipped++;
					NbFacesClipped++;

					// Compute A
					fRatio = (pB->z)/(pB->z - pA->z);
					pCurrVtxClipped->z = pCurrVtxClipped->oow = 1.f;
					pCurrVtxClipped->x = pB->x + (pA->x - pB->x)*fRatio;
					pCurrVtxClipped->y = pB->y + (pA->y - pB->y)*fRatio;
					pCurrVtxClipped->r = pB->r + (pA->r - pB->r)*fRatio;
					pCurrVtxClipped->g = pB->g + (pA->g - pB->g)*fRatio;
					pCurrVtxClipped->b = pB->b + (pA->b - pB->b)*fRatio;
					pCurrVtxClipped->tmuvtx[0].sow = pB->tmuvtx[0].sow + (pA->tmuvtx[0].sow - pB->tmuvtx[0].sow)*fRatio;
					pCurrVtxClipped->tmuvtx[0].tow = pB->tmuvtx[0].tow + (pA->tmuvtx[0].tow - pB->tmuvtx[0].tow)*fRatio;
					NbVtxClipped++; pCurrVtxClipped++;

					// Copy B
					/*pCurrVtxClipped->x = pB->x;					
					pCurrVtxClipped->y = pB->y;
					pCurrVtxClipped->z = pB->z;
					pCurrVtxClipped->r = pB->r;
					pCurrVtxClipped->g = pB->g;
					pCurrVtxClipped->b = pB->b;
					pCurrVtxClipped->a = pB->a;
					pCurrVtxClipped->tmuvtx[0].sow = pB->tmuvtx[0].sow;
					pCurrVtxClipped->tmuvtx[0].tow = pB->tmuvtx[0].tow;*/
					memcpy(pCurrVtxClipped, pB, sizeof(GrVertex)-sizeof(GrTmuVertex)-4);
					NbVtxClipped++; pCurrVtxClipped++;

					// Compute C
					fRatio = (pB->z)/(pB->z - pC->z);
					pCurrVtxClipped->z = pCurrVtxClipped->oow = 1.f;
					pCurrVtxClipped->x = pB->x + (pC->x - pB->x)*fRatio;
					pCurrVtxClipped->y = pB->y + (pC->y - pB->y)*fRatio;
					pCurrVtxClipped->r = pB->r + (pC->r - pB->r)*fRatio;
					pCurrVtxClipped->g = pB->g + (pC->g - pB->g)*fRatio;
					pCurrVtxClipped->b = pB->b + (pC->b - pB->b)*fRatio;
					pCurrVtxClipped->tmuvtx[0].sow = pB->tmuvtx[0].sow + (pC->tmuvtx[0].sow - pB->tmuvtx[0].sow)*fRatio;
					pCurrVtxClipped->tmuvtx[0].tow = pB->tmuvtx[0].tow + (pC->tmuvtx[0].tow - pB->tmuvtx[0].tow)*fRatio;
					NbVtxClipped++; pCurrVtxClipped++;

					pFace->IsVisible = false;
				}
				else
				{
					// A is NEG; keep B and C
					// We create A1 and A2
					// A-B-C become A1-B-C + C-A2-A1
					// We have A--A1--B; A--A2--C
				
					// A-A1-B
					pCurrFaceClipped->A = NbVtxClipped+0; // A1
					pCurrFaceClipped->B = NbVtxClipped+2; // B
					pCurrFaceClipped->C = NbVtxClipped+3; // C
					pCurrFaceClipped++;
					NbFacesClipped++;
					// C-A2-A1
					pCurrFaceClipped->A = NbVtxClipped+3; // C
					pCurrFaceClipped->B = NbVtxClipped+1; // A2
					pCurrFaceClipped->C = NbVtxClipped+0; // A1
					pCurrFaceClipped++;
					NbFacesClipped++;

					// Compute A1 (+0)
					fRatio = (pB->z)/(pB->z - pA->z);
					pCurrVtxClipped->z = pCurrVtxClipped->oow = 1.f;
					pCurrVtxClipped->x = pB->x + (pA->x - pB->x)*fRatio;
					pCurrVtxClipped->y = pB->y + (pA->y - pB->y)*fRatio;
					pCurrVtxClipped->r = pB->r + (pA->r - pB->r)*fRatio;
					pCurrVtxClipped->g = pB->g + (pA->g - pB->g)*fRatio;
					pCurrVtxClipped->b = pB->b + (pA->b - pB->b)*fRatio;
					pCurrVtxClipped->tmuvtx[0].sow = pB->tmuvtx[0].sow + (pA->tmuvtx[0].sow - pB->tmuvtx[0].sow)*fRatio;
					pCurrVtxClipped->tmuvtx[0].tow = pB->tmuvtx[0].tow + (pA->tmuvtx[0].tow - pB->tmuvtx[0].tow)*fRatio;
					NbVtxClipped++; pCurrVtxClipped++;

					// Compute A2 (+1)
					fRatio = (pC->z)/(pC->z - pA->z);
					pCurrVtxClipped->z = pCurrVtxClipped->oow = 1.f;
					pCurrVtxClipped->x = pC->x + (pA->x - pC->x)*fRatio;
					pCurrVtxClipped->y = pC->y + (pA->y - pC->y)*fRatio;
					pCurrVtxClipped->r = pC->r + (pA->r - pC->r)*fRatio;
					pCurrVtxClipped->g = pC->g + (pA->g - pC->g)*fRatio;
					pCurrVtxClipped->b = pC->b + (pA->b - pC->b)*fRatio;
					pCurrVtxClipped->tmuvtx[0].sow = pC->tmuvtx[0].sow + (pA->tmuvtx[0].sow - pC->tmuvtx[0].sow)*fRatio;
					pCurrVtxClipped->tmuvtx[0].tow = pC->tmuvtx[0].tow + (pA->tmuvtx[0].tow - pC->tmuvtx[0].tow)*fRatio;
					NbVtxClipped++; pCurrVtxClipped++;

					// Copy B (+2)
					/*pCurrVtxClipped->x = pB->x;					
					pCurrVtxClipped->y = pB->y;
					pCurrVtxClipped->z = pB->z;
					pCurrVtxClipped->r = pB->r;
					pCurrVtxClipped->g = pB->g;
					pCurrVtxClipped->b = pB->b;
					pCurrVtxClipped->a = pB->a;
					pCurrVtxClipped->tmuvtx[0].sow = pB->tmuvtx[0].sow;
					pCurrVtxClipped->tmuvtx[0].tow = pB->tmuvtx[0].tow;*/
					memcpy(pCurrVtxClipped, pB, sizeof(GrVertex)-sizeof(GrTmuVertex)-4);
					NbVtxClipped++; pCurrVtxClipped++;

					// Copy C (+3)
					/*pCurrVtxClipped->x = pC->x;					
					pCurrVtxClipped->y = pC->y;
					pCurrVtxClipped->z = pC->z;
					pCurrVtxClipped->r = pC->r;
					pCurrVtxClipped->g = pC->g;
					pCurrVtxClipped->b = pC->b;
					pCurrVtxClipped->a = pC->a;
					pCurrVtxClipped->tmuvtx[0].sow = pC->tmuvtx[0].sow;
					pCurrVtxClipped->tmuvtx[0].tow = pC->tmuvtx[0].tow;*/
					memcpy(pCurrVtxClipped, pC, sizeof(GrVertex)-sizeof(GrTmuVertex)-4);
					NbVtxClipped++; pCurrVtxClipped++;
					
					pFace->IsVisible = false;
				}
			}
		}
		else
		{
			if (IS_NEG(pB->z))
			{
				if (IS_NEG(pC->z))
				{
					// B and C are NEG; keep A
					pCurrFaceClipped->A = NbVtxClipped;
					pCurrFaceClipped->B = NbVtxClipped+1;
					pCurrFaceClipped->C = NbVtxClipped+2;
					pCurrFaceClipped++;
					NbFacesClipped++;

					// Copy A
					/*pCurrVtxClipped->x = pA->x;					
					pCurrVtxClipped->y = pA->y;
					pCurrVtxClipped->z = pA->z;
					pCurrVtxClipped->r = pA->r;
					pCurrVtxClipped->g = pA->g;
					pCurrVtxClipped->b = pA->b;
					pCurrVtxClipped->a = pA->a;
					pCurrVtxClipped->tmuvtx[0].sow = pA->tmuvtx[0].sow;
					pCurrVtxClipped->tmuvtx[0].tow = pA->tmuvtx[0].tow;*/
					memcpy(pCurrVtxClipped, pA, sizeof(GrVertex)-sizeof(GrTmuVertex)-4);
					NbVtxClipped++; pCurrVtxClipped++;

					// Compute B
					fRatio = (pA->z)/(pA->z - pB->z);
					pCurrVtxClipped->z = pCurrVtxClipped->oow = 1.f;
					pCurrVtxClipped->x = pA->x + (pB->x - pA->x)*fRatio;
					pCurrVtxClipped->y = pA->y + (pB->y - pA->y)*fRatio;
					pCurrVtxClipped->r = pA->r + (pB->r - pA->r)*fRatio;
					pCurrVtxClipped->g = pA->g + (pB->g - pA->g)*fRatio;
					pCurrVtxClipped->b = pA->b + (pB->b - pA->b)*fRatio;
					pCurrVtxClipped->tmuvtx[0].sow = pA->tmuvtx[0].sow + (pB->tmuvtx[0].sow - pA->tmuvtx[0].sow)*fRatio;
					pCurrVtxClipped->tmuvtx[0].tow = pA->tmuvtx[0].tow + (pB->tmuvtx[0].tow - pA->tmuvtx[0].tow)*fRatio;
					NbVtxClipped++; pCurrVtxClipped++;

					// Compute C
					fRatio = (pA->z)/(pA->z - pC->z);
					pCurrVtxClipped->z = pCurrVtxClipped->oow = 1.f;
					pCurrVtxClipped->x = pA->x + (pC->x - pA->x)*fRatio;
					pCurrVtxClipped->y = pA->y + (pC->y - pA->y)*fRatio;
					pCurrVtxClipped->r = pA->r + (pC->r - pA->r)*fRatio;
					pCurrVtxClipped->g = pA->g + (pC->g - pA->g)*fRatio;
					pCurrVtxClipped->b = pA->b + (pC->b - pA->b)*fRatio;
					pCurrVtxClipped->tmuvtx[0].sow = pA->tmuvtx[0].sow + (pC->tmuvtx[0].sow - pA->tmuvtx[0].sow)*fRatio;
					pCurrVtxClipped->tmuvtx[0].tow = pA->tmuvtx[0].tow + (pC->tmuvtx[0].tow - pA->tmuvtx[0].tow)*fRatio;
					NbVtxClipped++; pCurrVtxClipped++;

					pFace->IsVisible = false;
				}
				else
				{
					// B is NEG; keep A and C
					// We create B1 and B2
					// A-B-C become A-B1-C + B1-B2-C
					// We have A--B1--B; B--B2--C
				
					// A-B1-C
					pCurrFaceClipped->A = NbVtxClipped+2; // A
					pCurrFaceClipped->B = NbVtxClipped+0; // B1
					pCurrFaceClipped->C = NbVtxClipped+3; // C
					pCurrFaceClipped++;
					NbFacesClipped++;
					// B1-B2-C
					pCurrFaceClipped->A = NbVtxClipped+0; // B1
					pCurrFaceClipped->B = NbVtxClipped+1; // B2
					pCurrFaceClipped->C = NbVtxClipped+3; // C
					pCurrFaceClipped++;
					NbFacesClipped++;

					// Compute B1 (+0)
					fRatio = (pA->z)/(pA->z - pB->z);
					pCurrVtxClipped->z = pCurrVtxClipped->oow = 1.f;
					pCurrVtxClipped->x = pA->x + (pB->x - pA->x)*fRatio;
					pCurrVtxClipped->y = pA->y + (pB->y - pA->y)*fRatio;
					pCurrVtxClipped->r = pA->r + (pB->r - pA->r)*fRatio;
					pCurrVtxClipped->g = pA->g + (pB->g - pA->g)*fRatio;
					pCurrVtxClipped->b = pA->b + (pB->b - pA->b)*fRatio;
					pCurrVtxClipped->tmuvtx[0].sow = pA->tmuvtx[0].sow + (pB->tmuvtx[0].sow - pA->tmuvtx[0].sow)*fRatio;
					pCurrVtxClipped->tmuvtx[0].tow = pA->tmuvtx[0].tow + (pB->tmuvtx[0].tow - pA->tmuvtx[0].tow)*fRatio;
					NbVtxClipped++; pCurrVtxClipped++;

					// Compute B2 (+1)
					fRatio = (pC->z)/(pC->z - pB->z);
					pCurrVtxClipped->z = pCurrVtxClipped->oow = 1.f;
					pCurrVtxClipped->x = pC->x + (pB->x - pC->x)*fRatio;
					pCurrVtxClipped->y = pC->y + (pB->y - pC->y)*fRatio;
					pCurrVtxClipped->r = pC->r + (pB->r - pC->r)*fRatio;
					pCurrVtxClipped->g = pC->g + (pB->g - pC->g)*fRatio;
					pCurrVtxClipped->b = pC->b + (pB->b - pC->b)*fRatio;
					pCurrVtxClipped->tmuvtx[0].sow = pC->tmuvtx[0].sow + (pB->tmuvtx[0].sow - pC->tmuvtx[0].sow)*fRatio;
					pCurrVtxClipped->tmuvtx[0].tow = pC->tmuvtx[0].tow + (pB->tmuvtx[0].tow - pC->tmuvtx[0].tow)*fRatio;
					NbVtxClipped++; pCurrVtxClipped++;

					// Copy A (+2)
					/*pCurrVtxClipped->x = pA->x;					
					pCurrVtxClipped->y = pA->y;
					pCurrVtxClipped->z = pA->z;
					pCurrVtxClipped->r = pA->r;
					pCurrVtxClipped->g = pA->g;
					pCurrVtxClipped->b = pA->b;
					pCurrVtxClipped->a = pA->a;
					pCurrVtxClipped->tmuvtx[0].sow = pA->tmuvtx[0].sow;
					pCurrVtxClipped->tmuvtx[0].tow = pA->tmuvtx[0].tow;*/
					memcpy(pCurrVtxClipped, pA, sizeof(GrVertex)-sizeof(GrTmuVertex)-4);
					NbVtxClipped++; pCurrVtxClipped++;

					// Copy C (+3)
					/*pCurrVtxClipped->x = pC->x;					
					pCurrVtxClipped->y = pC->y;
					pCurrVtxClipped->z = pC->z;
					pCurrVtxClipped->r = pC->r;
					pCurrVtxClipped->g = pC->g;
					pCurrVtxClipped->b = pC->b;
					pCurrVtxClipped->a = pC->a;
					pCurrVtxClipped->tmuvtx[0].sow = pC->tmuvtx[0].sow;
					pCurrVtxClipped->tmuvtx[0].tow = pC->tmuvtx[0].tow;*/
					memcpy(pCurrVtxClipped, pC, sizeof(GrVertex)-sizeof(GrTmuVertex)-4);
					NbVtxClipped++; pCurrVtxClipped++;
				

					pFace->IsVisible = false;
				}
			}
			else
			{
				if (IS_NEG(pC->z))
				{
					// C is NEG; keep A and B
					// We create C1 and C2
					// A-B-C become A-B-C2 + C2-C1-A
					// We have A--C1--C; B--C2--C
				
					// A-B1-C
					pCurrFaceClipped->A = NbVtxClipped+2; // A
					pCurrFaceClipped->B = NbVtxClipped+3; // B
					pCurrFaceClipped->C = NbVtxClipped+1; // C2
					pCurrFaceClipped++;
					NbFacesClipped++;
					// B1-B2-C
					pCurrFaceClipped->A = NbVtxClipped+1; // C2
					pCurrFaceClipped->B = NbVtxClipped+0; // C1
					pCurrFaceClipped->C = NbVtxClipped+2; // A
					pCurrFaceClipped++;
					NbFacesClipped++;

					// Compute C1 (+0)
					fRatio = (pA->z)/(pA->z - pC->z);
					pCurrVtxClipped->z = pCurrVtxClipped->oow = 1.f;
					pCurrVtxClipped->x = pA->x + (pC->x - pA->x)*fRatio;
					pCurrVtxClipped->y = pA->y + (pC->y - pA->y)*fRatio;
					pCurrVtxClipped->r = pA->r + (pC->r - pA->r)*fRatio;
					pCurrVtxClipped->g = pA->g + (pC->g - pA->g)*fRatio;
					pCurrVtxClipped->b = pA->b + (pC->b - pA->b)*fRatio;
					pCurrVtxClipped->tmuvtx[0].sow = pA->tmuvtx[0].sow + (pC->tmuvtx[0].sow - pA->tmuvtx[0].sow)*fRatio;
					pCurrVtxClipped->tmuvtx[0].tow = pA->tmuvtx[0].tow + (pC->tmuvtx[0].tow - pA->tmuvtx[0].tow)*fRatio;
					NbVtxClipped++; pCurrVtxClipped++;

					// Compute C2 (+1)
					fRatio = (pB->z)/(pB->z - pC->z);
					pCurrVtxClipped->z = pCurrVtxClipped->oow = 1.f;
					pCurrVtxClipped->x = pB->x + (pC->x - pB->x)*fRatio;
					pCurrVtxClipped->y = pB->y + (pC->y - pB->y)*fRatio;
					pCurrVtxClipped->r = pB->r + (pC->r - pB->r)*fRatio;
					pCurrVtxClipped->g = pB->g + (pC->g - pB->g)*fRatio;
					pCurrVtxClipped->b = pB->b + (pC->b - pB->b)*fRatio;
					pCurrVtxClipped->tmuvtx[0].sow = pB->tmuvtx[0].sow + (pC->tmuvtx[0].sow - pB->tmuvtx[0].sow)*fRatio;
					pCurrVtxClipped->tmuvtx[0].tow = pB->tmuvtx[0].tow + (pC->tmuvtx[0].tow - pB->tmuvtx[0].tow)*fRatio;
					NbVtxClipped++; pCurrVtxClipped++;

					// Copy A (+2)
					/*pCurrVtxClipped->x = pA->x;					
					pCurrVtxClipped->y = pA->y;
					pCurrVtxClipped->z = pA->z;
					pCurrVtxClipped->r = pA->r;
					pCurrVtxClipped->g = pA->g;
					pCurrVtxClipped->b = pA->b;
					pCurrVtxClipped->a = pA->a;
					pCurrVtxClipped->tmuvtx[0].sow = pA->tmuvtx[0].sow;
					pCurrVtxClipped->tmuvtx[0].tow = pA->tmuvtx[0].tow;*/
					memcpy(pCurrVtxClipped, pA, sizeof(GrVertex)-sizeof(GrTmuVertex)-4);
					NbVtxClipped++; pCurrVtxClipped++;

					// Copy B (+3)
					/*pCurrVtxClipped->x = pB->x;					
					pCurrVtxClipped->y = pB->y;
					pCurrVtxClipped->z = pB->z;
					pCurrVtxClipped->r = pB->r;
					pCurrVtxClipped->g = pB->g;
					pCurrVtxClipped->b = pB->b;
					pCurrVtxClipped->a = pB->a;
					pCurrVtxClipped->tmuvtx[0].sow = pB->tmuvtx[0].sow;
					pCurrVtxClipped->tmuvtx[0].tow = pB->tmuvtx[0].tow;*/
					memcpy(pCurrVtxClipped, pB, sizeof(GrVertex)-sizeof(GrTmuVertex)-4);
					NbVtxClipped++; pCurrVtxClipped++;


					pFace->IsVisible = false;
				}
				else
				{
					// All pos ! See all !
					pFace->IsVisible = true;
				}
			}
		}

		pFace++;
	}
/*
	__asm{
		finit // initialize the FPU
		fwait // wait for operation to complete
		fstcw [tmp] // store FPU control word to memvar
		fwait // wait for operation to complete
		mov eax, [tmp] // move memvar to a register
		and eax, 0xfffffcff // mask off precision bits to set to 24-bit precision
		mov [tmp], eax // save control word to memory
		fldcw [tmp] // load control word back to FPU
		fwait // wait for operation to complete
	}
*/
	// projection
	pVertexIn = pObj->pVertexIn;
	pCurrentOut = pObj->pVertexOut;
	for(Cpt1=0;Cpt1<NbVertex;Cpt1++)
	{
		if (IS_NEG(pCurrentOut->z))
		{
			pVertexIn++;
			pCurrentOut++;
			continue;
		}
		pCurrentOut->tmuvtx[0].oow = pCurrentOut->oow = 1.f / pCurrentOut->z;
		pCurrentOut->x *= (oow320 = pCurrentOut->oow * 320.f);
		pCurrentOut->x += 320.f;
#ifdef WIN32
		__asm{
			mov eax, pCurrentOut
			fld	DWORD PTR [eax]
			fadd DWORD PTR vertex_snapper
			fsub DWORD PTR vertex_snapper
			fstp DWORD PTR [eax]
		}
#else		
		__asm__ __volatile("
                        pushl %%eax
			movl %1, %%eax
			flds (%%eax)
			fadds %0
			fsubs %0
			fstps (%%eax)
                        popl %%eax"
		  :
		  : "g" (vertex_snapper), "g" (pCurrentOut)
		);
#endif
		pCurrentOut->y *= oow320;
		pCurrentOut->y += 240.f;		
#ifdef WIN32
		__asm{
			mov eax, pCurrentOut
			fld	DWORD PTR [eax+4]
			fadd DWORD PTR vertex_snapper
			fsub DWORD PTR vertex_snapper
			fstp DWORD PTR [eax+4]
		}
#else
		__asm__ __volatile("
                        pushl %%eax
			movl %1, %%eax
			flds 4(%%eax)
			fadds %0
			fsubs %0
			fstps 4(%%eax)
                        popl %%eax"
		  :
		  : "g" (vertex_snapper), "g" (pCurrentOut)
		);
#endif
		/*tmp = pCurrentOut->x * 16;
		pCurrentOut->x = tmp / 16.f;
		tmp = pCurrentOut->y * 16;
		pCurrentOut->y = tmp / 16.f;*/
		pCurrentOut->tmuvtx[0].sow = pVertexIn->tmuvtx[0].sow * pCurrentOut->oow;
		pCurrentOut->tmuvtx[0].tow = pVertexIn->tmuvtx[0].tow * pCurrentOut->oow;

		pVertexIn++;
		pCurrentOut++;
	}

	pCurrentOut = VtxClipped;
	// project the new vertices
	for(Cpt1=0;Cpt1<NbVtxClipped;Cpt1++)
	{
		pCurrentOut->tmuvtx[0].oow = pCurrentOut->oow = 1.f / pCurrentOut->z;
		pCurrentOut->x *= (oow320 = pCurrentOut->oow * 320.f);
		pCurrentOut->x += 320.f;
		pCurrentOut->y *= oow320;
		pCurrentOut->y += 240.f;
#ifdef WIN32
		__asm{
			mov eax, pCurrentOut
			fld	DWORD PTR [eax]
			fadd DWORD PTR vertex_snapper
			fsub DWORD PTR vertex_snapper
			fstp DWORD PTR [eax]
		}
		__asm{
			mov eax, pCurrentOut
			fld	DWORD PTR [eax+4]
			fadd DWORD PTR vertex_snapper
			fsub DWORD PTR vertex_snapper
			fstp DWORD PTR [eax+4]
		}
#else
		__asm__ __volatile("
                        pushl %%eax
			movl %1, %%eax
			flds (%%eax)
			fadds %0
			fsubs %0
			fstps (%%eax)
			movl %1, %%eax
			flds 4(%%eax)
			fadds %0
			fsubs %0
			fstps 4(%%eax)
                        popl %%eax"
		  :
		  : "g" (vertex_snapper), "g" (pCurrentOut)
		);

#endif
		pCurrentOut->tmuvtx[0].sow *= pCurrentOut->oow;
		pCurrentOut->tmuvtx[0].tow *= pCurrentOut->oow;

		pCurrentOut++;
	}


	// Now we draw the first faces
	pFace = pObj->pFace;

	if (dwSowTow)
	{
		for(Cpt2=0;Cpt2<NbFaces;Cpt2++)
		{
			GrVertex *pA;
			GrVertex *pB;
			GrVertex *pC;

			// test if the vertexes are behind the camera
			// pA+32 ... = oow
			// yes => guDrawTriangleWithClip

			if (pFace[Cpt2].IsVisible==false)
			  goto endface;

			pA = pVertexOut+pFace[Cpt2].A;
			pB = pVertexOut+pFace[Cpt2].B;
			pC = pVertexOut+pFace[Cpt2].C;

			pA->tmuvtx[0].sow = pFace[Cpt2].SowA * pA->oow;
			pA->tmuvtx[0].tow = pFace[Cpt2].TowA * pA->oow;
			pB->tmuvtx[0].sow = pFace[Cpt2].SowB * pB->oow;
			pB->tmuvtx[0].tow = pFace[Cpt2].TowB * pB->oow;
			pC->tmuvtx[0].sow = pFace[Cpt2].SowC * pC->oow;
			pC->tmuvtx[0].tow = pFace[Cpt2].TowC * pC->oow;

			if (!( IS_NEG(pA->x) || IS_NEG(pB->x) || IS_NEG(pC->x) || IS_NEG(pA->y) || 
				 IS_NEG(pB->y) || IS_NEG(pC->y) ))
			  goto NoClip;

			guDrawTriangleWithClip(pA,pB,pC);
			continue;

NoClip:

			// is it in the secured area 1024x1024 ?
			// yes => no clip

			if ((pA->x < 1024) && (pB->x < 1024) && (pC->x < 1024) &&
				(pA->y < 1024) && (pB->y < 1024) && (pC->y < 1024))
			{
				grDrawTriangle(pA,pB,pC);
				continue;
			}

			// out of the secured area => clip
			
			guDrawTriangleWithClip(pA,pB,pC);

endface:

			{}
		}
	}
	else
	{
		for(Cpt2=0;Cpt2<NbFaces;Cpt2++)
		{
			GrVertex *pA;
			GrVertex *pB;
			GrVertex *pC;

			// test if the vertexes are behind the camera
			// pA+32 ... = oow
			// yes => guDrawTriangleWithClip

			if (pFace[Cpt2].IsVisible==false)
			  goto endface2;

			pA = pVertexOut+pFace[Cpt2].A;
			pB = pVertexOut+pFace[Cpt2].B;
			pC = pVertexOut+pFace[Cpt2].C;

			if (!( IS_NEG(pA->x) || IS_NEG(pB->x) || IS_NEG(pC->x) || IS_NEG(pA->y) || 
				 IS_NEG(pB->y) || IS_NEG(pC->y) ))
			  goto NoClip2;

			guDrawTriangleWithClip(pA,pB,pC);
			continue;

NoClip2:

			// is it in the secured area 1024x1024 ?
			// yes => no clip

			if ((pA->x < 1024) && (pB->x < 1024) && (pC->x < 1024) &&
				(pA->y < 1024) && (pB->y < 1024) && (pC->y < 1024))
			{
				grDrawTriangle(pA,pB,pC);
				continue;
			}

			// out of the secured area => clip
			
			guDrawTriangleWithClip(pA,pB,pC);

endface2:

			{}
		}
	}

	//
	// Now, we project the new faces
	//

	pFace = FacesClipped;

	for(Cpt2=0;Cpt2<NbFacesClipped;Cpt2++)
	{
		GrVertex *pA = VtxClipped+FacesClipped[Cpt2].A;
		GrVertex *pB = VtxClipped+FacesClipped[Cpt2].B;
		GrVertex *pC = VtxClipped+FacesClipped[Cpt2].C;

		// test if the vertexes are behind the camera
		// pA+32 ... = oow
		// yes => guDrawTriangleWithClip

		guDrawTriangleWithClip(pA,pB,pC);
		continue;

		// is it in the secured area 1024x1024 ?
		// yes => no clip

		if ((pA->x < 1024) && (pB->x < 1024) && (pC->x < 1024) &&
			(pA->y < 1024) && (pB->y < 1024) && (pC->y < 1024))
		{
			grDrawTriangle(pA,pB,pC);
			continue;
		}

		// out of the secured area => clip
		
		guDrawTriangleWithClip(pA,pB,pC);
	}


}

void ApplyMatrix(Obj3d* pObj, float *Matrix)
{
	FbVertex *pVertexIn;
	float x,y,z;
	DWORD Cpt1;

	pVertexIn = pObj->pVertexIn;

	for(Cpt1=0;Cpt1<pObj->NbVertex;Cpt1++)
	{
			x = Matrix[0] * pVertexIn->x + Matrix[1] * pVertexIn->y 
								+ Matrix[2] * pVertexIn->z + Matrix[3];
			y = Matrix[4] * pVertexIn->x + Matrix[5] * pVertexIn->y 
								+ Matrix[6] * pVertexIn->z + Matrix[7];
			z = Matrix[8] * pVertexIn->x + Matrix[9] * pVertexIn->y 
								+ Matrix[10] * pVertexIn->z + Matrix[11];

			pVertexIn->x = x;
			pVertexIn->y = y;
			pVertexIn->z = z;

			pVertexIn++;
	}
}









void DrawWithMatrixSowTow(Obj3d *pObj, float *Matrix, BOOL bGouraud, float *Gouraud)
{
	FbVertex *pVertexIn;
	GrVertex *pVertexOut, *pCurrentOut;
	DWORD NbVertex;
	Face *pFace;
	unsigned int NbFaces;
	DWORD Cpt1, Cpt2;
	float LightPower;
	long tmp;

	float oow320;

	pVertexIn = pObj->pVertexIn;
	pCurrentOut = pVertexOut = pObj->pVertexOut;
	NbVertex = pObj->NbVertex;	

	if (bGouraud == false)
	{
		for(Cpt1=0;Cpt1<NbVertex;Cpt1++)
		{
			pCurrentOut->z = Matrix[8] * pVertexIn->x + Matrix[9] * pVertexIn->y 
								+ Matrix[10] * pVertexIn->z + Matrix[11];
			pCurrentOut->x = Matrix[0] * pVertexIn->x + Matrix[1] * pVertexIn->y 
								+ Matrix[2] * pVertexIn->z + Matrix[3];
			pCurrentOut->y = Matrix[4] * pVertexIn->x + Matrix[5] * pVertexIn->y 
								+ Matrix[6] * pVertexIn->z + Matrix[7];

			pCurrentOut->tmuvtx[0].oow = pCurrentOut->oow = 1.f / pCurrentOut->z;
			pCurrentOut->x *= (oow320 = pCurrentOut->oow * 320.f);
			pCurrentOut->x += 320.f;
			pCurrentOut->y *= oow320;
			pCurrentOut->y += 240.f;
// pragma
			tmp = (DWORD)(pCurrentOut->x * 16);
			pCurrentOut->x = tmp / 16.0f;
			tmp = (DWORD)(pCurrentOut->y * 16);
			pCurrentOut->y = tmp / 16.f;
// pragma
			pCurrentOut->tmuvtx[0].sow = pVertexIn->tmuvtx[0].sow * pCurrentOut->oow;
			pCurrentOut->tmuvtx[0].tow = pVertexIn->tmuvtx[0].tow * pCurrentOut->oow;

			pVertexIn++;
			pCurrentOut++;
		}
	}
	else // Gouraud
	{
		float Gx, Gy, Gz;

		Gx = Gouraud[0] * 0 + Gouraud[0] * 0 + Gouraud[0] * 1;
		Gy = Gouraud[4] * 0 + Gouraud[5] * 0 + Gouraud[6] * 1;
		Gz = Gouraud[8] * 0 + Gouraud[9] * 0 + Gouraud[10] * 1;

		for(Cpt1=0;Cpt1<NbVertex;Cpt1++)
		{
			pCurrentOut->z = Matrix[8] * pVertexIn->x + Matrix[9] * pVertexIn->y 
								+ Matrix[10] * pVertexIn->z + Matrix[11];
			pCurrentOut->x = Matrix[0] * pVertexIn->x + Matrix[1] * pVertexIn->y 
								+ Matrix[2] * pVertexIn->z + Matrix[3];
			pCurrentOut->y = Matrix[4] * pVertexIn->x + Matrix[5] * pVertexIn->y 
								+ Matrix[6] * pVertexIn->z + Matrix[7];

			pCurrentOut->tmuvtx[0].oow = pCurrentOut->oow = 1.f / pCurrentOut->z;
			pCurrentOut->x *= (oow320 = pCurrentOut->oow * 320.f);
			pCurrentOut->x += 320.f;
			pCurrentOut->y *= oow320;
			pCurrentOut->y += 240.f;
// pragma
			tmp = (DWORD)(pCurrentOut->x * 16);
			pCurrentOut->x = tmp / 16.f;
			tmp = (DWORD)(pCurrentOut->y * 16);
			pCurrentOut->y = tmp / 16.f;
// pragma
			pCurrentOut->tmuvtx[0].sow = pVertexIn->tmuvtx[0].sow * pCurrentOut->oow;
			pCurrentOut->tmuvtx[0].tow = pVertexIn->tmuvtx[0].tow * pCurrentOut->oow;

			LightPower = ( Gx * pVertexIn->xNorm + Gy * pVertexIn->yNorm
							+ Gy * pVertexIn->zNorm);

			LightPower = LightPower * 255;
			//LightPower = LightPower * 127 + 128.f;
			
			if (LightPower<0)
				LightPower = 0;
			if (LightPower>255)
				LightPower = 255;

			pCurrentOut->r = LightPower;
			pCurrentOut->g = LightPower;
			pCurrentOut->b = LightPower;

			pVertexIn++;
			pCurrentOut++;
		}
	}
	
	NbFaces = pObj->NbFaces;
	pFace = pObj->pFace;

	for(Cpt2=0;Cpt2<NbFaces;Cpt2++, pFace++)
	{
		GrVertex *pA = pVertexOut+pFace->A;
		GrVertex *pB = pVertexOut+pFace->B;
		GrVertex *pC = pVertexOut+pFace->C;

		if ( IS_NEG(pA->oow) || IS_NEG(pB->oow) || IS_NEG(pC->oow) )
		  goto endface;

		pA->tmuvtx[0].sow = pFace->SowA * pA->oow;
		pA->tmuvtx[0].tow = pFace->TowA * pA->oow;
		pB->tmuvtx[0].sow = pFace->SowB * pB->oow;
		pB->tmuvtx[0].tow = pFace->TowB * pB->oow;
		pC->tmuvtx[0].sow = pFace->SowC * pC->oow;
		pC->tmuvtx[0].tow = pFace->TowC * pC->oow;
		
		if (!( IS_NEG(pA->x) || IS_NEG(pB->x) || IS_NEG(pC->x) || IS_NEG(pA->y) || 
		     IS_NEG(pB->y) || IS_NEG(pC->y) ))
		  goto NoClip;

		guDrawTriangleWithClip(pA,pB,pC);
		continue;

NoClip:

		// is it in the secured area 1024x1024 ?
		// yes => no clip

		if ((pA->x < 1024) && (pB->x < 1024) && (pC->x < 1024) &&
			(pA->y < 1024) && (pB->y < 1024) && (pC->y < 1024))
		{
			grDrawTriangle(pA,pB,pC);
		        //guDrawTriangleWithClip(pA,pB,pC);
			continue;
		}

		// out of the secured area => clip
		
		guDrawTriangleWithClip(pA,pB,pC);

endface:

		{}
	} // for

}






void DrawWithMatrixEnv(Obj3d *pObj, float *Matrix, float *Gouraud)
{
	FbVertex *pVertexIn;
	GrVertex *pVertexOut, *pCurrentOut;
	DWORD NbVertex;
	Face *pFace;
	unsigned int NbFaces;
	DWORD Cpt1, Cpt2;
	float LightPower;
	float oow320;
	float Gx, Gy, Gz;

	DWORD NbFacesClipped = 0;
	DWORD NbVtxClipped = 0;
	Face *pCurrFaceClipped;
	GrVertex *pCurrVtxClipped;

	pVertexIn = pObj->pVertexIn;
	pCurrentOut = pVertexOut = pObj->pVertexOut;
	NbVertex = pObj->NbVertex;	

	Gx = Gouraud[0] * 0 + Gouraud[1] * 0 + Gouraud[2] * -1;
	Gy = Gouraud[4] * 0 + Gouraud[5] * 0 + Gouraud[6] * -1;
	Gz = Gouraud[8] * 0 + Gouraud[9] * 0 + Gouraud[10] * -1;


	for(Cpt1=0;Cpt1<NbVertex;Cpt1++)
	{
		pCurrentOut->z = Matrix[8] * pVertexIn->x + Matrix[9] * pVertexIn->y 
							+ Matrix[10] * pVertexIn->z + Matrix[11];
		pCurrentOut->x = Matrix[0] * pVertexIn->x + Matrix[1] * pVertexIn->y 
							+ Matrix[2] * pVertexIn->z + Matrix[3];
		pCurrentOut->y = Matrix[4] * pVertexIn->x + Matrix[5] * pVertexIn->y 
							+ Matrix[6] * pVertexIn->z + Matrix[7];
		
		//pCurrentOut->tmuvtx[0].sow = pVertexIn->tmuvtx[0].sow;
		//pCurrentOut->tmuvtx[0].tow = pVertexIn->tmuvtx[0].tow;
		pCurrentOut->tmuvtx[0].sow = (Gy * pVertexIn->yNorm+Gx * pVertexIn->xNorm)*256.f;
		pCurrentOut->tmuvtx[0].tow = (Gz * pVertexIn->zNorm+Gx * pVertexIn->xNorm)*256.f;

		LightPower = ( Gx * pVertexIn->xNorm + Gy * pVertexIn->yNorm
						+ Gz * pVertexIn->zNorm);

		LightPower = LightPower * 255;
		//LightPower = LightPower * 127 + 128.f;
		
		if (LightPower<0)
			LightPower = 0;
		if (LightPower>255)
			LightPower = 255;

		pCurrentOut->r = LightPower;
		pCurrentOut->g = LightPower;
		pCurrentOut->b = LightPower;

		pVertexIn++;
		pCurrentOut++;
	}
	
	// Remove and create faces

	NbFaces = pObj->NbFaces;
	pFace = pObj->pFace;

	pCurrFaceClipped = &FacesClipped[0];
	pCurrVtxClipped = &VtxClipped[0];

	for(Cpt1=0;Cpt1<NbFaces;Cpt1++)
	{
		float fRatio;
		GrVertex *pA = pVertexOut+pFace->A;
		GrVertex *pB = pVertexOut+pFace->B;
		GrVertex *pC = pVertexOut+pFace->C;

		if (IS_NEG(pA->z))
		{
			if (IS_NEG(pB->z))
			{
				if (IS_NEG(pC->z))
				{
					// All neg ! See nothing
					pFace->IsVisible = false;
				}
				else
				{
					// A and B are NEG; keep C
					pCurrFaceClipped->A = NbVtxClipped;
					pCurrFaceClipped->B = NbVtxClipped+1;
					pCurrFaceClipped->C = NbVtxClipped+2;
					pCurrFaceClipped++;
					NbFacesClipped++;

					// Compute A
					fRatio = (pC->z)/(pC->z - pA->z);
					pCurrVtxClipped->z = pCurrVtxClipped->oow = 1.f;
					pCurrVtxClipped->x = pC->x + (pA->x - pC->x)*fRatio;
					pCurrVtxClipped->y = pC->y + (pA->y - pC->y)*fRatio;
					pCurrVtxClipped->r = pC->r + (pA->r - pC->r)*fRatio;
					pCurrVtxClipped->g = pC->g + (pA->g - pC->g)*fRatio;
					pCurrVtxClipped->b = pC->b + (pA->b - pC->b)*fRatio;
					pCurrVtxClipped->tmuvtx[0].sow = pC->tmuvtx[0].sow + (pA->tmuvtx[0].sow - pC->tmuvtx[0].sow)*fRatio;
					pCurrVtxClipped->tmuvtx[0].tow = pC->tmuvtx[0].tow + (pA->tmuvtx[0].tow - pC->tmuvtx[0].tow)*fRatio;
					NbVtxClipped++; pCurrVtxClipped++;

					// Compute B
					fRatio = (pC->z)/(pC->z - pB->z);
					pCurrVtxClipped->z = pCurrVtxClipped->oow = 1.f;
					pCurrVtxClipped->x = pC->x + (pB->x - pC->x)*fRatio;
					pCurrVtxClipped->y = pC->y + (pB->y - pC->y)*fRatio;
					pCurrVtxClipped->r = pC->r + (pB->r - pC->r)*fRatio;
					pCurrVtxClipped->g = pC->g + (pB->g - pC->g)*fRatio;
					pCurrVtxClipped->b = pC->b + (pB->b - pC->b)*fRatio;
					pCurrVtxClipped->tmuvtx[0].sow = pC->tmuvtx[0].sow + (pB->tmuvtx[0].sow - pC->tmuvtx[0].sow)*fRatio;
					pCurrVtxClipped->tmuvtx[0].tow = pC->tmuvtx[0].tow + (pB->tmuvtx[0].tow - pC->tmuvtx[0].tow)*fRatio;
					NbVtxClipped++; pCurrVtxClipped++;
					// Copy C
					/*pCurrVtxClipped->x = pC->x;					
					pCurrVtxClipped->y = pC->y;
					pCurrVtxClipped->z = pC->z;
					pCurrVtxClipped->r = pC->r;
					pCurrVtxClipped->g = pC->g;
					pCurrVtxClipped->b = pC->b;
					pCurrVtxClipped->a = pC->a;
					pCurrVtxClipped->tmuvtx[0].sow = pC->tmuvtx[0].sow;
					pCurrVtxClipped->tmuvtx[0].tow = pC->tmuvtx[0].tow;*/
					memcpy(pCurrVtxClipped, pC, sizeof(GrVertex)-sizeof(GrTmuVertex)-4);
					NbVtxClipped++; pCurrVtxClipped++;

					pFace->IsVisible = false;
				}
			}
			else
			{
				if (IS_NEG(pC->z))
				{
					// A and C are NEG; keep B
					pCurrFaceClipped->A = NbVtxClipped;
					pCurrFaceClipped->B = NbVtxClipped+1;
					pCurrFaceClipped->C = NbVtxClipped+2;
					pCurrFaceClipped++;
					NbFacesClipped++;

					// Compute A
					fRatio = (pB->z)/(pB->z - pA->z);
					pCurrVtxClipped->z = pCurrVtxClipped->oow = 1.f;
					pCurrVtxClipped->x = pB->x + (pA->x - pB->x)*fRatio;
					pCurrVtxClipped->y = pB->y + (pA->y - pB->y)*fRatio;
					pCurrVtxClipped->r = pB->r + (pA->r - pB->r)*fRatio;
					pCurrVtxClipped->g = pB->g + (pA->g - pB->g)*fRatio;
					pCurrVtxClipped->b = pB->b + (pA->b - pB->b)*fRatio;
					pCurrVtxClipped->tmuvtx[0].sow = pB->tmuvtx[0].sow + (pA->tmuvtx[0].sow - pB->tmuvtx[0].sow)*fRatio;
					pCurrVtxClipped->tmuvtx[0].tow = pB->tmuvtx[0].tow + (pA->tmuvtx[0].tow - pB->tmuvtx[0].tow)*fRatio;
					NbVtxClipped++; pCurrVtxClipped++;

					// Copy B
					/*pCurrVtxClipped->x = pB->x;					
					pCurrVtxClipped->y = pB->y;
					pCurrVtxClipped->z = pB->z;
					pCurrVtxClipped->r = pB->r;
					pCurrVtxClipped->g = pB->g;
					pCurrVtxClipped->b = pB->b;
					pCurrVtxClipped->a = pB->a;
					pCurrVtxClipped->tmuvtx[0].sow = pB->tmuvtx[0].sow;
					pCurrVtxClipped->tmuvtx[0].tow = pB->tmuvtx[0].tow;*/
					memcpy(pCurrVtxClipped, pB, sizeof(GrVertex)-sizeof(GrTmuVertex)-4);
					NbVtxClipped++; pCurrVtxClipped++;

					// Compute C
					fRatio = (pB->z)/(pB->z - pC->z);
					pCurrVtxClipped->z = pCurrVtxClipped->oow = 1.f;
					pCurrVtxClipped->x = pB->x + (pC->x - pB->x)*fRatio;
					pCurrVtxClipped->y = pB->y + (pC->y - pB->y)*fRatio;
					pCurrVtxClipped->r = pB->r + (pC->r - pB->r)*fRatio;
					pCurrVtxClipped->g = pB->g + (pC->g - pB->g)*fRatio;
					pCurrVtxClipped->b = pB->b + (pC->b - pB->b)*fRatio;
					pCurrVtxClipped->tmuvtx[0].sow = pB->tmuvtx[0].sow + (pC->tmuvtx[0].sow - pB->tmuvtx[0].sow)*fRatio;
					pCurrVtxClipped->tmuvtx[0].tow = pB->tmuvtx[0].tow + (pC->tmuvtx[0].tow - pB->tmuvtx[0].tow)*fRatio;
					NbVtxClipped++; pCurrVtxClipped++;

					pFace->IsVisible = false;
				}
				else
				{
					// A is NEG; keep B and C
					// We create A1 and A2
					// A-B-C become A1-B-C + C-A2-A1
					// We have A--A1--B; A--A2--C
				
					// A-A1-B
					pCurrFaceClipped->A = NbVtxClipped+0; // A1
					pCurrFaceClipped->B = NbVtxClipped+2; // B
					pCurrFaceClipped->C = NbVtxClipped+3; // C
					pCurrFaceClipped++;
					NbFacesClipped++;
					// C-A2-A1
					pCurrFaceClipped->A = NbVtxClipped+3; // C
					pCurrFaceClipped->B = NbVtxClipped+1; // A2
					pCurrFaceClipped->C = NbVtxClipped+0; // A1
					pCurrFaceClipped++;
					NbFacesClipped++;

					// Compute A1 (+0)
					fRatio = (pB->z)/(pB->z - pA->z);
					pCurrVtxClipped->z = pCurrVtxClipped->oow = 1.f;
					pCurrVtxClipped->x = pB->x + (pA->x - pB->x)*fRatio;
					pCurrVtxClipped->y = pB->y + (pA->y - pB->y)*fRatio;
					pCurrVtxClipped->r = pB->r + (pA->r - pB->r)*fRatio;
					pCurrVtxClipped->g = pB->g + (pA->g - pB->g)*fRatio;
					pCurrVtxClipped->b = pB->b + (pA->b - pB->b)*fRatio;
					pCurrVtxClipped->tmuvtx[0].sow = pB->tmuvtx[0].sow + (pA->tmuvtx[0].sow - pB->tmuvtx[0].sow)*fRatio;
					pCurrVtxClipped->tmuvtx[0].tow = pB->tmuvtx[0].tow + (pA->tmuvtx[0].tow - pB->tmuvtx[0].tow)*fRatio;
					NbVtxClipped++; pCurrVtxClipped++;

					// Compute A2 (+1)
					fRatio = (pC->z)/(pC->z - pA->z);
					pCurrVtxClipped->z = pCurrVtxClipped->oow = 1.f;
					pCurrVtxClipped->x = pC->x + (pA->x - pC->x)*fRatio;
					pCurrVtxClipped->y = pC->y + (pA->y - pC->y)*fRatio;
					pCurrVtxClipped->r = pC->r + (pA->r - pC->r)*fRatio;
					pCurrVtxClipped->g = pC->g + (pA->g - pC->g)*fRatio;
					pCurrVtxClipped->b = pC->b + (pA->b - pC->b)*fRatio;
					pCurrVtxClipped->tmuvtx[0].sow = pC->tmuvtx[0].sow + (pA->tmuvtx[0].sow - pC->tmuvtx[0].sow)*fRatio;
					pCurrVtxClipped->tmuvtx[0].tow = pC->tmuvtx[0].tow + (pA->tmuvtx[0].tow - pC->tmuvtx[0].tow)*fRatio;
					NbVtxClipped++; pCurrVtxClipped++;

					// Copy B (+2)
					/*pCurrVtxClipped->x = pB->x;					
					pCurrVtxClipped->y = pB->y;
					pCurrVtxClipped->z = pB->z;
					pCurrVtxClipped->r = pB->r;
					pCurrVtxClipped->g = pB->g;
					pCurrVtxClipped->b = pB->b;
					pCurrVtxClipped->a = pB->a;
					pCurrVtxClipped->tmuvtx[0].sow = pB->tmuvtx[0].sow;
					pCurrVtxClipped->tmuvtx[0].tow = pB->tmuvtx[0].tow;*/
					memcpy(pCurrVtxClipped, pB, sizeof(GrVertex)-sizeof(GrTmuVertex)-4);
					NbVtxClipped++; pCurrVtxClipped++;

					// Copy C (+3)
					/*pCurrVtxClipped->x = pC->x;					
					pCurrVtxClipped->y = pC->y;
					pCurrVtxClipped->z = pC->z;
					pCurrVtxClipped->r = pC->r;
					pCurrVtxClipped->g = pC->g;
					pCurrVtxClipped->b = pC->b;
					pCurrVtxClipped->a = pC->a;
					pCurrVtxClipped->tmuvtx[0].sow = pC->tmuvtx[0].sow;
					pCurrVtxClipped->tmuvtx[0].tow = pC->tmuvtx[0].tow;*/
					memcpy(pCurrVtxClipped, pC, sizeof(GrVertex)-sizeof(GrTmuVertex)-4);
					NbVtxClipped++; pCurrVtxClipped++;
					
					pFace->IsVisible = false;
				}
			}
		}
		else
		{
			if (IS_NEG(pB->z))
			{
				if (IS_NEG(pC->z))
				{
					// B and C are NEG; keep A
					pCurrFaceClipped->A = NbVtxClipped;
					pCurrFaceClipped->B = NbVtxClipped+1;
					pCurrFaceClipped->C = NbVtxClipped+2;
					pCurrFaceClipped++;
					NbFacesClipped++;

					// Copy A
					/*pCurrVtxClipped->x = pA->x;					
					pCurrVtxClipped->y = pA->y;
					pCurrVtxClipped->z = pA->z;
					pCurrVtxClipped->r = pA->r;
					pCurrVtxClipped->g = pA->g;
					pCurrVtxClipped->b = pA->b;
					pCurrVtxClipped->a = pA->a;
					pCurrVtxClipped->tmuvtx[0].sow = pA->tmuvtx[0].sow;
					pCurrVtxClipped->tmuvtx[0].tow = pA->tmuvtx[0].tow;*/
					memcpy(pCurrVtxClipped, pA, sizeof(GrVertex)-sizeof(GrTmuVertex)-4);
					NbVtxClipped++; pCurrVtxClipped++;

					// Compute B
					fRatio = (pA->z)/(pA->z - pB->z);
					pCurrVtxClipped->z = pCurrVtxClipped->oow = 1.f;
					pCurrVtxClipped->x = pA->x + (pB->x - pA->x)*fRatio;
					pCurrVtxClipped->y = pA->y + (pB->y - pA->y)*fRatio;
					pCurrVtxClipped->r = pA->r + (pB->r - pA->r)*fRatio;
					pCurrVtxClipped->g = pA->g + (pB->g - pA->g)*fRatio;
					pCurrVtxClipped->b = pA->b + (pB->b - pA->b)*fRatio;
					pCurrVtxClipped->tmuvtx[0].sow = pA->tmuvtx[0].sow + (pB->tmuvtx[0].sow - pA->tmuvtx[0].sow)*fRatio;
					pCurrVtxClipped->tmuvtx[0].tow = pA->tmuvtx[0].tow + (pB->tmuvtx[0].tow - pA->tmuvtx[0].tow)*fRatio;
					NbVtxClipped++; pCurrVtxClipped++;

					// Compute C
					fRatio = (pA->z)/(pA->z - pC->z);
					pCurrVtxClipped->z = pCurrVtxClipped->oow = 1.f;
					pCurrVtxClipped->x = pA->x + (pC->x - pA->x)*fRatio;
					pCurrVtxClipped->y = pA->y + (pC->y - pA->y)*fRatio;
					pCurrVtxClipped->r = pA->r + (pC->r - pA->r)*fRatio;
					pCurrVtxClipped->g = pA->g + (pC->g - pA->g)*fRatio;
					pCurrVtxClipped->b = pA->b + (pC->b - pA->b)*fRatio;
					pCurrVtxClipped->tmuvtx[0].sow = pA->tmuvtx[0].sow + (pC->tmuvtx[0].sow - pA->tmuvtx[0].sow)*fRatio;
					pCurrVtxClipped->tmuvtx[0].tow = pA->tmuvtx[0].tow + (pC->tmuvtx[0].tow - pA->tmuvtx[0].tow)*fRatio;
					NbVtxClipped++; pCurrVtxClipped++;

					pFace->IsVisible = false;
				}
				else
				{
					// B is NEG; keep A and C
					// We create B1 and B2
					// A-B-C become A-B1-C + B1-B2-C
					// We have A--B1--B; B--B2--C
				
					// A-B1-C
					pCurrFaceClipped->A = NbVtxClipped+2; // A
					pCurrFaceClipped->B = NbVtxClipped+0; // B1
					pCurrFaceClipped->C = NbVtxClipped+3; // C
					pCurrFaceClipped++;
					NbFacesClipped++;
					// B1-B2-C
					pCurrFaceClipped->A = NbVtxClipped+0; // B1
					pCurrFaceClipped->B = NbVtxClipped+1; // B2
					pCurrFaceClipped->C = NbVtxClipped+3; // C
					pCurrFaceClipped++;
					NbFacesClipped++;

					// Compute B1 (+0)
					fRatio = (pA->z)/(pA->z - pB->z);
					pCurrVtxClipped->z = pCurrVtxClipped->oow = 1.f;
					pCurrVtxClipped->x = pA->x + (pB->x - pA->x)*fRatio;
					pCurrVtxClipped->y = pA->y + (pB->y - pA->y)*fRatio;
					pCurrVtxClipped->r = pA->r + (pB->r - pA->r)*fRatio;
					pCurrVtxClipped->g = pA->g + (pB->g - pA->g)*fRatio;
					pCurrVtxClipped->b = pA->b + (pB->b - pA->b)*fRatio;
					pCurrVtxClipped->tmuvtx[0].sow = pA->tmuvtx[0].sow + (pB->tmuvtx[0].sow - pA->tmuvtx[0].sow)*fRatio;
					pCurrVtxClipped->tmuvtx[0].tow = pA->tmuvtx[0].tow + (pB->tmuvtx[0].tow - pA->tmuvtx[0].tow)*fRatio;
					NbVtxClipped++; pCurrVtxClipped++;

					// Compute B2 (+1)
					fRatio = (pC->z)/(pC->z - pB->z);
					pCurrVtxClipped->z = pCurrVtxClipped->oow = 1.f;
					pCurrVtxClipped->x = pC->x + (pB->x - pC->x)*fRatio;
					pCurrVtxClipped->y = pC->y + (pB->y - pC->y)*fRatio;
					pCurrVtxClipped->r = pC->r + (pB->r - pC->r)*fRatio;
					pCurrVtxClipped->g = pC->g + (pB->g - pC->g)*fRatio;
					pCurrVtxClipped->b = pC->b + (pB->b - pC->b)*fRatio;
					pCurrVtxClipped->tmuvtx[0].sow = pC->tmuvtx[0].sow + (pB->tmuvtx[0].sow - pC->tmuvtx[0].sow)*fRatio;
					pCurrVtxClipped->tmuvtx[0].tow = pC->tmuvtx[0].tow + (pB->tmuvtx[0].tow - pC->tmuvtx[0].tow)*fRatio;
					NbVtxClipped++; pCurrVtxClipped++;

					// Copy A (+2)
					/*pCurrVtxClipped->x = pA->x;					
					pCurrVtxClipped->y = pA->y;
					pCurrVtxClipped->z = pA->z;
					pCurrVtxClipped->r = pA->r;
					pCurrVtxClipped->g = pA->g;
					pCurrVtxClipped->b = pA->b;
					pCurrVtxClipped->a = pA->a;
					pCurrVtxClipped->tmuvtx[0].sow = pA->tmuvtx[0].sow;
					pCurrVtxClipped->tmuvtx[0].tow = pA->tmuvtx[0].tow;*/
					memcpy(pCurrVtxClipped, pA, sizeof(GrVertex)-sizeof(GrTmuVertex)-4);
					NbVtxClipped++; pCurrVtxClipped++;

					// Copy C (+3)
					/*pCurrVtxClipped->x = pC->x;					
					pCurrVtxClipped->y = pC->y;
					pCurrVtxClipped->z = pC->z;
					pCurrVtxClipped->r = pC->r;
					pCurrVtxClipped->g = pC->g;
					pCurrVtxClipped->b = pC->b;
					pCurrVtxClipped->a = pC->a;
					pCurrVtxClipped->tmuvtx[0].sow = pC->tmuvtx[0].sow;
					pCurrVtxClipped->tmuvtx[0].tow = pC->tmuvtx[0].tow;*/
					memcpy(pCurrVtxClipped, pC, sizeof(GrVertex)-sizeof(GrTmuVertex)-4);
					NbVtxClipped++; pCurrVtxClipped++;
				

					pFace->IsVisible = false;
				}
			}
			else
			{
				if (IS_NEG(pC->z))
				{
					// C is NEG; keep A and B
					// We create C1 and C2
					// A-B-C become A-B-C2 + C2-C1-A
					// We have A--C1--C; B--C2--C
				
					// A-B1-C
					pCurrFaceClipped->A = NbVtxClipped+2; // A
					pCurrFaceClipped->B = NbVtxClipped+3; // B
					pCurrFaceClipped->C = NbVtxClipped+1; // C2
					pCurrFaceClipped++;
					NbFacesClipped++;
					// B1-B2-C
					pCurrFaceClipped->A = NbVtxClipped+1; // C2
					pCurrFaceClipped->B = NbVtxClipped+0; // C1
					pCurrFaceClipped->C = NbVtxClipped+2; // A
					pCurrFaceClipped++;
					NbFacesClipped++;

					// Compute C1 (+0)
					fRatio = (pA->z)/(pA->z - pC->z);
					pCurrVtxClipped->z = pCurrVtxClipped->oow = 1.f;
					pCurrVtxClipped->x = pA->x + (pC->x - pA->x)*fRatio;
					pCurrVtxClipped->y = pA->y + (pC->y - pA->y)*fRatio;
					pCurrVtxClipped->r = pA->r + (pC->r - pA->r)*fRatio;
					pCurrVtxClipped->g = pA->g + (pC->g - pA->g)*fRatio;
					pCurrVtxClipped->b = pA->b + (pC->b - pA->b)*fRatio;
					pCurrVtxClipped->tmuvtx[0].sow = pA->tmuvtx[0].sow + (pC->tmuvtx[0].sow - pA->tmuvtx[0].sow)*fRatio;
					pCurrVtxClipped->tmuvtx[0].tow = pA->tmuvtx[0].tow + (pC->tmuvtx[0].tow - pA->tmuvtx[0].tow)*fRatio;
					NbVtxClipped++; pCurrVtxClipped++;

					// Compute C2 (+1)
					fRatio = (pB->z)/(pB->z - pC->z);
					pCurrVtxClipped->z = pCurrVtxClipped->oow = 1.f;
					pCurrVtxClipped->x = pB->x + (pC->x - pB->x)*fRatio;
					pCurrVtxClipped->y = pB->y + (pC->y - pB->y)*fRatio;
					pCurrVtxClipped->r = pB->r + (pC->r - pB->r)*fRatio;
					pCurrVtxClipped->g = pB->g + (pC->g - pB->g)*fRatio;
					pCurrVtxClipped->b = pB->b + (pC->b - pB->b)*fRatio;
					pCurrVtxClipped->tmuvtx[0].sow = pB->tmuvtx[0].sow + (pC->tmuvtx[0].sow - pB->tmuvtx[0].sow)*fRatio;
					pCurrVtxClipped->tmuvtx[0].tow = pB->tmuvtx[0].tow + (pC->tmuvtx[0].tow - pB->tmuvtx[0].tow)*fRatio;
					NbVtxClipped++; pCurrVtxClipped++;

					// Copy A (+2)
					/*pCurrVtxClipped->x = pA->x;					
					pCurrVtxClipped->y = pA->y;
					pCurrVtxClipped->z = pA->z;
					pCurrVtxClipped->r = pA->r;
					pCurrVtxClipped->g = pA->g;
					pCurrVtxClipped->b = pA->b;
					pCurrVtxClipped->a = pA->a;
					pCurrVtxClipped->tmuvtx[0].sow = pA->tmuvtx[0].sow;
					pCurrVtxClipped->tmuvtx[0].tow = pA->tmuvtx[0].tow;*/
					memcpy(pCurrVtxClipped, pA, sizeof(GrVertex)-sizeof(GrTmuVertex)-4);
					NbVtxClipped++; pCurrVtxClipped++;

					// Copy B (+3)
					/*pCurrVtxClipped->x = pB->x;					
					pCurrVtxClipped->y = pB->y;
					pCurrVtxClipped->z = pB->z;
					pCurrVtxClipped->r = pB->r;
					pCurrVtxClipped->g = pB->g;
					pCurrVtxClipped->b = pB->b;
					pCurrVtxClipped->a = pB->a;
					pCurrVtxClipped->tmuvtx[0].sow = pB->tmuvtx[0].sow;
					pCurrVtxClipped->tmuvtx[0].tow = pB->tmuvtx[0].tow;*/
					memcpy(pCurrVtxClipped, pB, sizeof(GrVertex)-sizeof(GrTmuVertex)-4);
					NbVtxClipped++; pCurrVtxClipped++;


					pFace->IsVisible = false;
				}
				else
				{
					// All pos ! See all !
					pFace->IsVisible = true;
				}
			}
		}

		pFace++;
	}

	// projection
	pVertexIn = pObj->pVertexIn;
	pCurrentOut = pObj->pVertexOut;
	for(Cpt1=0;Cpt1<NbVertex;Cpt1++)
	{
		if (IS_NEG(pCurrentOut->z))
		{
			pVertexIn++;
			pCurrentOut++;
			continue;
		}
		pCurrentOut->tmuvtx[0].oow = pCurrentOut->oow = 1.f / pCurrentOut->z;
		pCurrentOut->x *= (oow320 = pCurrentOut->oow * 320.f);
		pCurrentOut->x += 320.f;
		pCurrentOut->y *= oow320;
		pCurrentOut->y += 240.f;
		pCurrentOut->tmuvtx[0].sow = pCurrentOut->tmuvtx[0].sow * pCurrentOut->oow;
		pCurrentOut->tmuvtx[0].tow = pCurrentOut->tmuvtx[0].tow * pCurrentOut->oow;

		pVertexIn++;
		pCurrentOut++;
	}

	pCurrentOut = VtxClipped;
	// project the new vertices
	for(Cpt1=0;Cpt1<NbVtxClipped;Cpt1++)
	{
		pCurrentOut->tmuvtx[0].oow = pCurrentOut->oow = 1.f / pCurrentOut->z;
		pCurrentOut->x *= (oow320 = pCurrentOut->oow * 320.f);
		pCurrentOut->x += 320.f;
		pCurrentOut->y *= oow320;
		pCurrentOut->y += 240.f;
		pCurrentOut->tmuvtx[0].sow *= pCurrentOut->oow;
		pCurrentOut->tmuvtx[0].tow *= pCurrentOut->oow;

		pCurrentOut++;
	}


	// Now we draw the first faces
	pFace = pObj->pFace;

	for(Cpt2=0;Cpt2<NbFaces;Cpt2++)
	{
		GrVertex *pA;
		GrVertex *pB;
		GrVertex *pC;

		// test if the vertexes are behind the camera
		// pA+32 ... = oow
		// yes => guDrawTriangleWithClip

		if (pFace[Cpt2].IsVisible==false)
		  goto endface;

		pA = pVertexOut+pFace[Cpt2].A;
		pB = pVertexOut+pFace[Cpt2].B;
		pC = pVertexOut+pFace[Cpt2].C;

		if (!( IS_NEG(pA->x) || IS_NEG(pB->x) || IS_NEG(pC->x) || IS_NEG(pA->y) || 
		     IS_NEG(pB->y) || IS_NEG(pC->y) ))
		  goto NoClip;

		guDrawTriangleWithClip(pA,pB,pC);
		continue;

NoClip:

		// is it in the secured area 1024x1024 ?
		// yes => no clip

		if ((pA->x < 1024) && (pB->x < 1024) && (pC->x < 1024) &&
			(pA->y < 1024) && (pB->y < 1024) && (pC->y < 1024))
		{
			grDrawTriangle(pA,pB,pC);
			continue;
		}

		// out of the secured area => clip
		
		guDrawTriangleWithClip(pA,pB,pC);

endface:

		{}
	}

	//
	// Now, we project the new faces
	//

	pFace = FacesClipped;

	for(Cpt2=0;Cpt2<NbFacesClipped;Cpt2++)
	{
		GrVertex *pA = VtxClipped+FacesClipped[Cpt2].A;
		GrVertex *pB = VtxClipped+FacesClipped[Cpt2].B;
		GrVertex *pC = VtxClipped+FacesClipped[Cpt2].C;

		// test if the vertexes are behind the camera
		// pA+32 ... = oow
		// yes => guDrawTriangleWithClip

		guDrawTriangleWithClip(pA,pB,pC);
		continue;

		// is it in the secured area 1024x1024 ?
		// yes => no clip

		if ((pA->x < 1024) && (pB->x < 1024) && (pC->x < 1024) &&
			(pA->y < 1024) && (pB->y < 1024) && (pC->y < 1024))
		{
			grDrawTriangle(pA,pB,pC);
		        //guDrawTriangleWithClip(pA,pB,pC);
			continue;
		}

		// out of the secured area => clip
		
		guDrawTriangleWithClip(pA,pB,pC);
	}


}

void Draw3dSprite(float fWidth, float fHeight, float *Matrix)
{
	float x,y,z, oow, oow256, oow320;
	// A--B
	// |  |
	// D--C
	GrVertex A,B,C,D;

	z = Matrix[11];
	if (z<=0)
		return;
	oow = 1/z;
	oow256 = 256.f*oow;
	oow320 = 320.f*oow;
	x = Matrix[3];
	y = Matrix[7];

	A.x = (x-fWidth)*oow320+320;
	A.y = (y-fHeight)*oow320+240;
	A.tmuvtx[0].oow = A.oow = oow;
	A.tmuvtx[0].sow = 0;
	A.tmuvtx[0].tow = 0;

	B.x = (x+fWidth)*oow320+320;
	B.y = (y-fHeight)*oow320+240;
	B.tmuvtx[0].oow = B.oow = oow;
	B.tmuvtx[0].sow = oow256;
	B.tmuvtx[0].tow = 0;
	
	C.x = (x+fWidth)*oow320+320;
	C.y = (y+fHeight)*oow320+240;
	C.tmuvtx[0].oow = C.oow = oow;
	C.tmuvtx[0].sow = oow256;
	C.tmuvtx[0].tow = oow256;
	
	D.x = (x-fWidth)*oow320+320;
	D.y = (y+fHeight)*oow320+240;
	D.tmuvtx[0].oow = D.oow = oow;
	D.tmuvtx[0].sow = 0;
	D.tmuvtx[0].tow = oow256;

	guDrawTriangleWithClip(&A, &B, &C);
	guDrawTriangleWithClip(&C, &D, &A);
}

void Draw3dSpriteSimple(float fWidth, float fHeight, 
						float x, float y, float z)
{
	float oow, oow256, oow320;
	// A--B
	// |  |
	// D--C
	GrVertex A,B,C,D;

	if (z<=0)
		return;
	oow = 1/z;
	oow256 = 256.f*oow;
	oow320 = 320.f*oow;

	A.x = (x-fWidth)*oow320+320;
	A.y = (y-fHeight)*oow320+240;
	A.tmuvtx[0].oow = A.oow = oow;
	A.tmuvtx[0].sow = 0;
	A.tmuvtx[0].tow = 0;

	B.x = (x+fWidth)*oow320+320;
	B.y = (y-fHeight)*oow320+240;
	B.tmuvtx[0].oow = B.oow = oow;
	B.tmuvtx[0].sow = oow256;
	B.tmuvtx[0].tow = 0;
	
	C.x = (x+fWidth)*oow320+320;
	C.y = (y+fHeight)*oow320+240;
	C.tmuvtx[0].oow = C.oow = oow;
	C.tmuvtx[0].sow = oow256;
	C.tmuvtx[0].tow = oow256;
	
	D.x = (x-fWidth)*oow320+320;
	D.y = (y+fHeight)*oow320+240;
	D.tmuvtx[0].oow = D.oow = oow;
	D.tmuvtx[0].sow = 0;
	D.tmuvtx[0].tow = oow256;

	guDrawTriangleWithClip(&A, &B, &C);
	guDrawTriangleWithClip(&C, &D, &A);
}


void Draw3dSpriteEx(float fWidth, float fHeight, float fMinSow, float fMinTow,
					float fMaxSow, float fMaxTow, float *Matrix)
{
	float x,y,z, oow, oow256, oow320;
	// A--B
	// |  |
	// D--C
	GrVertex A,B,C,D;

	z = Matrix[11];
	if (z<=0)
		return;
	oow = 1/z;
	oow256 = 256.f*oow;
	oow320 = 320.f*oow;
	x = Matrix[3];
	y = Matrix[7];

	A.x = (x-fWidth)*oow320+320;
	A.y = (y-fHeight)*oow320+240;
	A.tmuvtx[0].oow = A.oow = oow;
	A.tmuvtx[0].sow = fMinSow*oow;
	A.tmuvtx[0].tow = fMinTow*oow;

	B.x = (x+fWidth)*oow320+320;
	B.y = (y-fHeight)*oow320+240;
	B.tmuvtx[0].oow = B.oow = oow;
	B.tmuvtx[0].sow = fMaxSow*oow;
	B.tmuvtx[0].tow = fMinTow*oow;
	
	C.x = (x+fWidth)*oow320+320;
	C.y = (y+fHeight)*oow320+240;
	C.tmuvtx[0].oow = C.oow = oow;
	C.tmuvtx[0].sow = fMaxSow*oow;
	C.tmuvtx[0].tow = fMaxTow*oow;
	
	D.x = (x-fWidth)*oow320+320;
	D.y = (y+fHeight)*oow320+240;
	D.tmuvtx[0].oow = D.oow = oow;
	D.tmuvtx[0].sow = fMinSow*oow;
	D.tmuvtx[0].tow = fMaxTow*oow;

	guDrawTriangleWithClip(&A, &B, &C);
	guDrawTriangleWithClip(&C, &D, &A);
}


void LoadObject(Obj3d *pObj, DWORD VtxId, DWORD FaceId)
{
	FILE *file;
	DWORD dwDummy;
	DWORD Cpt1;
	unsigned short A,B,C;
	DWORD bMapping;

	file = fopen(PackageName, "rb");
	SeekToSubfile(file, VtxId, &dwDummy);
	fread(&bMapping, 4, 1, file);
	fread(&pObj->NbVertex, 4, 1, file);
	pObj->pVertexIn = (FbVertex*)malloc(sizeof(FbVertex)*pObj->NbVertex);
	pObj->pVertexOut = (GrVertex*)malloc(sizeof(GrVertex)*pObj->NbVertex);
	if (bMapping)
	{
		for(Cpt1=0;Cpt1<pObj->NbVertex;Cpt1++)
		{
			fread(&pObj->pVertexIn[Cpt1].x, 4, 1, file);
			fread(&pObj->pVertexIn[Cpt1].y, 4, 1, file);
			fread(&pObj->pVertexIn[Cpt1].z, 4, 1, file);
			fread(&pObj->pVertexIn[Cpt1].tmuvtx[0].tow, 4, 1, file);
			pObj->pVertexOut[Cpt1].a = 0.f;
		}
	}
	else
	{
		for(Cpt1=0;Cpt1<pObj->NbVertex;Cpt1++)
		{
			fread(&pObj->pVertexIn[Cpt1].x, 4, 1, file);
			fread(&pObj->pVertexIn[Cpt1].y, 4, 1, file);
			fread(&pObj->pVertexIn[Cpt1].z, 4, 1, file);
			pObj->pVertexIn[Cpt1].tmuvtx[0].sow = 0;
			pObj->pVertexIn[Cpt1].tmuvtx[0].tow = 0;
			pObj->pVertexOut[Cpt1].a = 0.f;
		}
	}

	SeekToSubfile(file, FaceId, &dwDummy);
	fread(&pObj->NbFaces, 4, 1, file);
	pObj->pFace = (Face*)malloc(sizeof(Face)*pObj->NbFaces);
	for(Cpt1=0;Cpt1<pObj->NbFaces;Cpt1++)
	{
		fread(&A, 2, 1, file);
		fread(&B, 2, 1, file);
		fread(&C, 2, 1, file);
		pObj->pFace[Cpt1].A = A;
		pObj->pFace[Cpt1].B = B;
		pObj->pFace[Cpt1].C = C;
	}
	fclose(file);

}
